"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, workspace_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the snapshots for the specified WorkSpace.

    Args:
        workspace_id(str): The identifier of the WorkSpace.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.snapshot.describe_all(
                ctx, workspace_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.snapshot.describe_all workspace_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_workspace_snapshots",
        op_kwargs={"WorkspaceId": workspace_id},
    )
