"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "property"


async def modify(hub, ctx, workspace_id: str, workspace_properties: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see  Modify a WorkSpace.

    Args:
        workspace_id(str): The identifier of the WorkSpace.
        workspace_properties(Dict): The properties of the WorkSpace.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.property_.modify(
                ctx, workspace_id=value, workspace_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.property.modify workspace_id=value, workspace_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="modify_workspace_properties",
        op_kwargs={
            "WorkspaceId": workspace_id,
            "WorkspaceProperties": workspace_properties,
        },
    )
