"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(hub, ctx, workspaces: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more WorkSpaces. This operation is asynchronous and returns before the WorkSpaces are created.

    Args:
        workspaces(List): The WorkSpaces to create. You can specify up to 25 WorkSpaces.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.create_multiple(ctx, workspaces=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.create_multiple workspaces=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="create_workspaces",
        op_kwargs={"Workspaces": workspaces},
    )


async def describe_all(
    hub,
    ctx,
    workspace_ids: List = None,
    directory_id: str = None,
    user_name: str = None,
    bundle_id: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified WorkSpaces. You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify only one filter at a time.

    Args:
        workspace_ids(List, optional): The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter. Because the CreateWorkspaces operation is asynchronous, the identifier it returns is not immediately available. If you immediately call DescribeWorkspaces with this identifier, no information is returned. Defaults to None.
        directory_id(str, optional): The identifier of the directory. In addition, you can optionally specify a specific directory user (see UserName). You cannot combine this parameter with any other filter. Defaults to None.
        user_name(str, optional): The name of the directory user. You must specify this parameter with DirectoryId. Defaults to None.
        bundle_id(str, optional): The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter. Defaults to None.
        limit(int, optional): The maximum number of items to return. Defaults to None.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_workspaces",
        op_kwargs={
            "WorkspaceIds": workspace_ids,
            "DirectoryId": directory_id,
            "UserName": user_name,
            "BundleId": bundle_id,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def migrate(hub, ctx, source_workspace_id: str, bundle_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume. The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the user volume from the last available snapshot of the original WorkSpace. During migration, the original D:\Users\%USERNAME% user profile folder is renamed to D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated. A new D:\Users\%USERNAME%\ folder is generated by the new OS. Certain files in the old user profile are moved to the new user profile. For available migration scenarios, details about what happens during migration, and best practices, see Migrate a WorkSpace.

    Args:
        source_workspace_id(str): The identifier of the WorkSpace to migrate from.
        bundle_id(str): The identifier of the target bundle type to migrate the WorkSpace to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.migrate(
                ctx, source_workspace_id=value, bundle_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.migrate source_workspace_id=value, bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="migrate_workspace",
        op_kwargs={"SourceWorkspaceId": source_workspace_id, "BundleId": bundle_id},
    )


async def reboot(hub, ctx, reboot_workspace_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Reboots the specified WorkSpaces. You cannot reboot a WorkSpace unless its state is AVAILABLE or UNHEALTHY. This operation is asynchronous and returns before the WorkSpaces have rebooted.

    Args:
        reboot_workspace_requests(List): The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.reboot(
                ctx, reboot_workspace_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.reboot reboot_workspace_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="reboot_workspaces",
        op_kwargs={"RebootWorkspaceRequests": reboot_workspace_requests},
    )


async def rebuild(hub, ctx, rebuild_workspace_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Rebuilds the specified WorkSpace. You cannot rebuild a WorkSpace unless its state is AVAILABLE, ERROR, UNHEALTHY, STOPPED, or REBOOTING. Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see Rebuild a WorkSpace. This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.

    Args:
        rebuild_workspace_requests(List): The WorkSpace to rebuild. You can specify a single WorkSpace.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.rebuild(
                ctx, rebuild_workspace_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.rebuild rebuild_workspace_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="rebuild_workspaces",
        op_kwargs={"RebuildWorkspaceRequests": rebuild_workspace_requests},
    )


async def restore(hub, ctx, workspace_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Restores the specified WorkSpace to its last known healthy state. You cannot restore a WorkSpace unless its state is  AVAILABLE, ERROR, UNHEALTHY, or STOPPED. Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see Restore a WorkSpace. This operation is asynchronous and returns before the WorkSpace is completely restored.

    Args:
        workspace_id(str): The identifier of the WorkSpace.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.restore(ctx, workspace_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.restore workspace_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="restore_workspace",
        op_kwargs={"WorkspaceId": workspace_id},
    )


async def start(hub, ctx, start_workspace_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Starts the specified WorkSpaces. You cannot start a WorkSpace unless it has a running mode of AutoStop and a state of STOPPED.

    Args:
        start_workspace_requests(List): The WorkSpaces to start. You can specify up to 25 WorkSpaces.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.start(
                ctx, start_workspace_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.start start_workspace_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="start_workspaces",
        op_kwargs={"StartWorkspaceRequests": start_workspace_requests},
    )


async def stop(hub, ctx, stop_workspace_requests: List) -> Dict:
    r"""
    **Autogenerated function**

     Stops the specified WorkSpaces. You cannot stop a WorkSpace unless it has a running mode of AutoStop and a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.

    Args:
        stop_workspace_requests(List): The WorkSpaces to stop. You can specify up to 25 WorkSpaces.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.stop(
                ctx, stop_workspace_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.stop stop_workspace_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="stop_workspaces",
        op_kwargs={"StopWorkspaceRequests": stop_workspace_requests},
    )


async def terminate(hub, ctx, terminate_workspace_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Terminates the specified WorkSpaces.  Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to archive any user data, contact AWS Support before terminating the WorkSpace.  You can terminate a WorkSpace that is in any state except SUSPENDED. This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the TERMINATED state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using  DescribeWorkSpaces. If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.  Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the AWS Directory Services pricing terms. To delete empty directories, see  Delete the Directory for Your WorkSpaces. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.

    Args:
        terminate_workspace_requests(List): The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.init.terminate(
                ctx, terminate_workspace_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.init.terminate terminate_workspace_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="terminate_workspaces",
        op_kwargs={"TerminateWorkspaceRequests": terminate_workspace_requests},
    )
