"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def copy(
    hub,
    ctx,
    name: str,
    source_image_id: str,
    source_region: str,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified image from the specified Region to the current Region. For more information about copying images, see  Copy a Custom WorkSpaces Image.  In the China (Ningxia) Region, you can copy images only within the same Region. In the AWS GovCloud (US-West) Region, to copy images to and from other AWS Regions, contact AWS Support.   Before copying a shared image, be sure to verify that it has been shared from the correct AWS account. To determine if an image has been shared and to see the AWS account ID that owns an image, use the DescribeWorkSpaceImages and DescribeWorkspaceImagePermissions API operations.

    Args:
        name(str): The name of the image.
        description(str, optional): A description of the image. Defaults to None.
        source_image_id(str): The identifier of the source image.
        source_region(str): The identifier of the source Region.
        tags(List, optional): The tags for the image. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.image.init.copy(ctx, name=value, source_image_id=value, source_region=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.image.init.copy name=value, source_image_id=value, source_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="copy_workspace_image",
        op_kwargs={
            "Name": name,
            "Description": description,
            "SourceImageId": source_image_id,
            "SourceRegion": source_region,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, image_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts.

    Args:
        image_id(str): The identifier of the image.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.image.init.delete(ctx, image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.image.init.delete image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="delete_workspace_image",
        op_kwargs={"ImageId": image_id},
    )


async def describe_all(
    hub,
    ctx,
    image_ids: List = None,
    image_type: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described.

    Args:
        image_ids(List, optional): The identifier of the image. Defaults to None.
        image_type(str, optional): The type (owned or shared) of the image. Defaults to None.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of items to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.image.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.image.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_workspace_images",
        op_kwargs={
            "ImageIds": image_ids,
            "ImageType": image_type,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def import_(
    hub,
    ctx,
    ec2_image_id: str,
    ingestion_process: str,
    image_name: str,
    image_description: str,
    tags: List = None,
    applications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Imports the specified Windows 10 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your AWS account, and you must own the image. For more information about creating BYOL images, see  Bring Your Own Windows Desktop Licenses.

    Args:
        ec2_image_id(str): The identifier of the EC2 image.
        ingestion_process(str): The ingestion process to be used when importing the image, depending on which protocol you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol (WSP). To use WSP, specify a value that ends in _WSP. To use PCoIP, specify a value that does not end in _WSP.  For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify BYOL_REGULAR or BYOL_REGULAR_WSP, depending on the protocol.
        image_name(str): The name of the WorkSpace image.
        image_description(str): The description of the WorkSpace image.
        tags(List, optional): The tags. Each WorkSpaces resource can have a maximum of 50 tags. Defaults to None.
        applications(List, optional): If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10 BYOL images. For more information about subscribing to Office for BYOL images, see  Bring Your Own Windows Desktop Licenses.  Although this parameter is an array, only one item is allowed at this time. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.image.init.import(ctx, ec2_image_id=value, ingestion_process=value, image_name=value, image_description=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.image.init.import ec2_image_id=value, ingestion_process=value, image_name=value, image_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="import_workspace_image",
        op_kwargs={
            "Ec2ImageId": ec2_image_id,
            "IngestionProcess": ingestion_process,
            "ImageName": image_name,
            "ImageDescription": image_description,
            "Tags": tags,
            "Applications": applications,
        },
    )
