"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.  Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the AWS Directory Services pricing terms. To delete empty directories, see  Delete the Directory for Your WorkSpaces. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.

    Args:
        directory_id(str): The identifier of the directory. If any WorkSpaces are registered to this directory, you must remove them before you deregister the directory, or you will receive an OperationNotSupportedException error.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.directory.deregister(
                ctx, directory_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.directory.deregister directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="deregister_workspace_directory",
        op_kwargs={"DirectoryId": directory_id},
    )


async def describe_all(
    hub, ctx, directory_ids: List = None, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the available directories that are registered with Amazon WorkSpaces.

    Args:
        directory_ids(List, optional): The identifiers of the directories. If the value is null, all directories are retrieved. Defaults to None.
        limit(int, optional): The maximum number of directories to return. Defaults to None.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.directory.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.directory.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_workspace_directories",
        op_kwargs={
            "DirectoryIds": directory_ids,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def register(
    hub,
    ctx,
    directory_id: str,
    enable_work_docs: bool,
    subnet_ids: List = None,
    enable_self_service: bool = None,
    tenancy: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see  Creating the workspaces_DefaultRole Role.

    Args:
        directory_id(str): The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.
        subnet_ids(List, optional): The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error. Defaults to None.
        enable_work_docs(bool): Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set EnableWorkDocs to disabled, and try again.
        enable_self_service(bool, optional): Indicates whether self-service capabilities are enabled or disabled. Defaults to None.
        tenancy(str, optional): Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to DEDICATED and your AWS account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see Bring Your Own Windows Desktop Images. Defaults to None.
        tags(List, optional): The tags associated with the directory. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.directory.register(
                ctx, directory_id=value, enable_work_docs=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.directory.register directory_id=value, enable_work_docs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="register_workspace_directory",
        op_kwargs={
            "DirectoryId": directory_id,
            "SubnetIds": subnet_ids,
            "EnableWorkDocs": enable_work_docs,
            "EnableSelfService": enable_self_service,
            "Tenancy": tenancy,
            "Tags": tags,
        },
    )
