"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "creation_property"


async def modify(
    hub, ctx, resource_id: str, workspace_creation_properties: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Modify the default properties used to create WorkSpaces.

    Args:
        resource_id(str): The identifier of the directory.
        workspace_creation_properties(Dict): The default properties for creating WorkSpaces.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.creation_property_.modify(
                ctx, resource_id=value, workspace_creation_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.creation_property.modify resource_id=value, workspace_creation_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="modify_workspace_creation_properties",
        op_kwargs={
            "ResourceId": resource_id,
            "WorkspaceCreationProperties": workspace_creation_properties,
        },
    )
