"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, workspace_ids: List = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the connection status of the specified WorkSpaces.

    Args:
        workspace_ids(List, optional): The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces. Defaults to None.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.connection_status.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.connection_status.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_workspaces_connection_status",
        op_kwargs={"WorkspaceIds": workspace_ids, "NextToken": next_token},
    )
