"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    bundle_name: str,
    bundle_description: str,
    image_id: str,
    compute_type: Dict,
    user_storage: Dict,
    root_storage: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see  Create a Custom WorkSpaces Image and Bundle.

    Args:
        bundle_name(str): The name of the bundle.
        bundle_description(str): The description of the bundle.
        image_id(str): The identifier of the image that is used to create the bundle.
        compute_type(Dict): Describes the compute type of the bundle.
        user_storage(Dict): Describes the user volume for a WorkSpace bundle.
        root_storage(Dict, optional): Describes the root volume for a WorkSpace bundle. Defaults to None.
        tags(List, optional): The tags associated with the bundle.  To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your IAM user permissions to use workspaces:CreateTags.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.bundle.create(
                ctx,
                bundle_name=value,
                bundle_description=value,
                image_id=value,
                compute_type=value,
                user_storage=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.bundle.create bundle_name=value, bundle_description=value, image_id=value, compute_type=value, user_storage=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="create_workspace_bundle",
        op_kwargs={
            "BundleName": bundle_name,
            "BundleDescription": bundle_description,
            "ImageId": image_id,
            "ComputeType": compute_type,
            "UserStorage": user_storage,
            "RootStorage": root_storage,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, bundle_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see  Delete a Custom WorkSpaces Bundle or Image.

    Args:
        bundle_id(str, optional): The identifier of the bundle. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.bundle.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.bundle.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="delete_workspace_bundle",
        op_kwargs={"BundleId": bundle_id},
    )


async def describe_all(
    hub, ctx, bundle_ids: List = None, owner: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes the available WorkSpace bundles. You can filter the results using either bundle ID or owner, but not both.

    Args:
        bundle_ids(List, optional): The identifiers of the bundles. You cannot combine this parameter with any other filter. Defaults to None.
        owner(str, optional): The owner of the bundles. You cannot combine this parameter with any other filter. To describe the bundles provided by AWS, specify AMAZON. To describe the bundles that belong to your account, don't specify a value. Defaults to None.
        next_token(str, optional): The token for the next set of results. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.bundle.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.bundle.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_workspace_bundles",
        op_kwargs={"BundleIds": bundle_ids, "Owner": owner, "NextToken": next_token},
    )


async def update(hub, ctx, bundle_id: str = None, image_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see  Update a Custom WorkSpaces Bundle.  Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or delete and recreate them.

    Args:
        bundle_id(str, optional): The identifier of the bundle. Defaults to None.
        image_id(str, optional): The identifier of the image. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.bundle.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.bundle.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="update_workspace_bundle",
        op_kwargs={"BundleId": bundle_id, "ImageId": image_id},
    )
