"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "access_property"


async def modify(hub, ctx, resource_id: str, workspace_access_properties: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see  Control Device Access.

    Args:
        resource_id(str): The identifier of the directory.
        workspace_access_properties(Dict): The device types and operating systems to enable or disable for access.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.access_property_.modify(
                ctx, resource_id=value, workspace_access_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.access_property.modify resource_id=value, workspace_access_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="modify_workspace_access_properties",
        op_kwargs={
            "ResourceId": resource_id,
            "WorkspaceAccessProperties": workspace_access_properties,
        },
    )
