"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, resource_id: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates the specified tags for the specified WorkSpaces resource.

    Args:
        resource_id(str): The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.
        tags(List): The tags. Each WorkSpaces resource can have a maximum of 50 tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.tags.create(ctx, resource_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.tags.create resource_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="create_tags",
        op_kwargs={"ResourceId": resource_id, "Tags": tags},
    )


async def delete(hub, ctx, resource_id: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified tags from the specified WorkSpaces resource.

    Args:
        resource_id(str): The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.
        tag_keys(List): The tag keys.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.tags.delete(ctx, resource_id=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.tags.delete resource_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="delete_tags",
        op_kwargs={"ResourceId": resource_id, "TagKeys": tag_keys},
    )


async def describe(hub, ctx, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified tags for the specified WorkSpaces resource.

    Args:
        resource_id(str): The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.tags.describe(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.tags.describe resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_tags",
        op_kwargs={"ResourceId": resource_id},
    )
