"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(hub, ctx, resource_id: str, selfservice_permissions: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the self-service WorkSpace management capabilities for your users. For more information, see Enable Self-Service WorkSpace Management Capabilities for Your Users.

    Args:
        resource_id(str): The identifier of the directory.
        selfservice_permissions(Dict): The permissions to enable or disable self-service capabilities.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.selfservice_permission.modify(
                ctx, resource_id=value, selfservice_permissions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.selfservice_permission.modify resource_id=value, selfservice_permissions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="modify_selfservice_permissions",
        op_kwargs={
            "ResourceId": resource_id,
            "SelfservicePermissions": selfservice_permissions,
        },
    )
