"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def update(hub, ctx, group_id: str, user_rules: List) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the current rules of the specified IP access control group with the specified rules.

    Args:
        group_id(str): The identifier of the group.
        user_rules(List): One or more rules.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.rule_of_ip_group.update(
                ctx, group_id=value, user_rules=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.rule_of_ip_group.update group_id=value, user_rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="update_rules_of_ip_group",
        op_kwargs={"GroupId": group_id, "UserRules": user_rules},
    )
