"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def authorize(hub, ctx, group_id: str, user_rules: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more rules to the specified IP access control group. This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the rules.

    Args:
        group_id(str): The identifier of the group.
        user_rules(List): The rules to add to the group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.ip.rule.authorize(
                ctx, group_id=value, user_rules=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.ip.rule.authorize group_id=value, user_rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="authorize_ip_rules",
        op_kwargs={"GroupId": group_id, "UserRules": user_rules},
    )


async def revoke(hub, ctx, group_id: str, user_rules: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more rules from the specified IP access control group.

    Args:
        group_id(str): The identifier of the group.
        user_rules(List): The rules to remove from the group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.ip.rule.revoke(ctx, group_id=value, user_rules=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.ip.rule.revoke group_id=value, user_rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="revoke_ip_rules",
        op_kwargs={"GroupId": group_id, "UserRules": user_rules},
    )
