"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, directory_id: str, group_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified IP access control group with the specified directory.

    Args:
        directory_id(str): The identifier of the directory.
        group_ids(List): The identifiers of one or more IP access control groups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.ip.group.associate(
                ctx, directory_id=value, group_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.ip.group.associate directory_id=value, group_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="associate_ip_groups",
        op_kwargs={"DirectoryId": directory_id, "GroupIds": group_ids},
    )


async def create(
    hub,
    ctx,
    group_name: str,
    group_desc: str = None,
    user_rules: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an IP access control group. An IP access control group provides you with the ability to control the IP addresses from which users are allowed to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and then associate the group with your directory. You can add rules when you create the group or at any time using AuthorizeIpRules. There is a default IP access control group associated with your directory. If you don't associate an IP access control group with your directory, the default group is used. The default group includes a default rule that allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for your directory.

    Args:
        group_name(str): The name of the group.
        group_desc(str, optional): The description of the group. Defaults to None.
        user_rules(List, optional): The rules to add to the group. Defaults to None.
        tags(List, optional): The tags. Each WorkSpaces resource can have a maximum of 50 tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.ip.group.create(ctx, group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.ip.group.create group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="create_ip_group",
        op_kwargs={
            "GroupName": group_name,
            "GroupDesc": group_desc,
            "UserRules": user_rules,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified IP access control group. You cannot delete an IP access control group that is associated with a directory.

    Args:
        group_id(str): The identifier of the IP access control group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.ip.group.delete(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.ip.group.delete group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="delete_ip_group",
        op_kwargs={"GroupId": group_id},
    )


async def describe_all(
    hub, ctx, group_ids: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your IP access control groups.

    Args:
        group_ids(List, optional): The identifiers of one or more IP access control groups. Defaults to None.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of items to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.ip.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.ip.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_ip_groups",
        op_kwargs={
            "GroupIds": group_ids,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def disassociate(hub, ctx, directory_id: str, group_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified IP access control group from the specified directory.

    Args:
        directory_id(str): The identifier of the directory.
        group_ids(List): The identifiers of one or more IP access control groups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.ip.group.disassociate(
                ctx, directory_id=value, group_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.ip.group.disassociate directory_id=value, group_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="disassociate_ip_groups",
        op_kwargs={"DirectoryId": directory_id, "GroupIds": group_ids},
    )
