"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    alias_ids: List = None,
    resource_id: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see  Cross-Region Redirection for Amazon WorkSpaces.

    Args:
        alias_ids(List, optional): The identifiers of the connection aliases to describe. Defaults to None.
        resource_id(str, optional): The identifier of the directory associated with the connection alias. Defaults to None.
        limit(int, optional): The maximum number of connection aliases to return. Defaults to None.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.connection_aliase.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.connection_aliase.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_connection_aliases",
        op_kwargs={
            "AliasIds": alias_ids,
            "ResourceId": resource_id,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
