"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, alias_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the permissions that the owner of a connection alias has granted to another AWS account for the specified connection alias. For more information, see  Cross-Region Redirection for Amazon WorkSpaces.

    Args:
        alias_id(str): The identifier of the connection alias.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.connection_alias.permission.describe_all(
                ctx, alias_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.connection_alias.permission.describe_all alias_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_connection_alias_permissions",
        op_kwargs={
            "AliasId": alias_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(hub, ctx, alias_id: str, connection_alias_permission: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see  Cross-Region Redirection for Amazon WorkSpaces.    Before performing this operation, call  DescribeConnectionAliases to make sure that the current state of the connection alias is CREATED.   To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.

    Args:
        alias_id(str): The identifier of the connection alias that you want to update permissions for.
        connection_alias_permission(Dict): Indicates whether to share or unshare the connection alias with the specified AWS account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.connection_alias.permission.update(
                ctx, alias_id=value, connection_alias_permission=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.connection_alias.permission.update alias_id=value, connection_alias_permission=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="update_connection_alias_permission",
        op_kwargs={
            "AliasId": alias_id,
            "ConnectionAliasPermission": connection_alias_permission,
        },
    )
