"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, alias_id: str, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see  Cross-Region Redirection for Amazon WorkSpaces.  Before performing this operation, call  DescribeConnectionAliases to make sure that the current state of the connection alias is CREATED.

    Args:
        alias_id(str): The identifier of the connection alias.
        resource_id(str): The identifier of the directory to associate the connection alias with.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.connection_alias.init.associate(
                ctx, alias_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.connection_alias.init.associate alias_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="associate_connection_alias",
        op_kwargs={"AliasId": alias_id, "ResourceId": resource_id},
    )


async def create(hub, ctx, connection_string: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates the specified connection alias for use with cross-Region redirection. For more information, see  Cross-Region Redirection for Amazon WorkSpaces.

    Args:
        connection_string(str): A connection string in the form of a fully qualified domain name (FQDN), such as www.example.com.  After you create a connection string, it is always associated to your AWS account. You cannot recreate the same connection string with a different account, even if you delete all instances of it from the original account. The connection string is globally reserved for your account. .
        tags(List, optional): The tags to associate with the connection alias. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.connection_alias.init.create(
                ctx, connection_string=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.connection_alias.init.create connection_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="create_connection_alias",
        op_kwargs={"ConnectionString": connection_string, "Tags": tags},
    )


async def delete(hub, ctx, alias_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified connection alias. For more information, see  Cross-Region Redirection for Amazon WorkSpaces.   If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your WorkSpaces users, you must take certain precautions to prevent potential security issues. For more information, see  Security Considerations if You Stop Using Cross-Region Redirection.   To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.

    Args:
        alias_id(str): The identifier of the connection alias to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.connection_alias.init.delete(ctx, alias_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.connection_alias.init.delete alias_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="delete_connection_alias",
        op_kwargs={"AliasId": alias_id},
    )


async def disassociate(hub, ctx, alias_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different AWS Regions. For more information, see  Cross-Region Redirection for Amazon WorkSpaces.  Before performing this operation, call  DescribeConnectionAliases to make sure that the current state of the connection alias is CREATED.

    Args:
        alias_id(str): The identifier of the connection alias to disassociate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.connection_alias.init.disassociate(
                ctx, alias_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.connection_alias.init.disassociate alias_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="disassociate_connection_alias",
        op_kwargs={"AliasId": alias_id},
    )
