"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "client_property"


async def describe_all(hub, ctx, resource_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified Amazon WorkSpaces clients.

    Args:
        resource_ids(List): The resource identifier, in the form of directory IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.client_property_.describe_all(ctx, resource_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.client_property.describe_all resource_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_client_properties",
        op_kwargs={"ResourceIds": resource_ids},
    )


async def modify(hub, ctx, resource_id: str, client_properties: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the properties of the specified Amazon WorkSpaces clients.

    Args:
        resource_id(str): The resource identifiers, in the form of directory IDs.
        client_properties(Dict): Information about the Amazon WorkSpaces client.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.client_property_.modify(
                ctx, resource_id=value, client_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.client_property.modify resource_id=value, client_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="modify_client_properties",
        op_kwargs={"ResourceId": resource_id, "ClientProperties": client_properties},
    )
