"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "available_management_cidr_range"


async def list_all(
    hub,
    ctx,
    management_cidr_range_constraint: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL).  This operation can be run only by AWS accounts that are enabled for BYOL. If your account isn't enabled for BYOL, you'll receive an AccessDeniedException error. The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.

    Args:
        management_cidr_range_constraint(str): The IP address range to search. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).
        max_results(int, optional): The maximum number of items to return. Defaults to None.
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.available_management_cidr_range_.list_all(
                ctx, management_cidr_range_constraint=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.available_management_cidr_range.list_all management_cidr_range_constraint=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="list_available_management_cidr_ranges",
        op_kwargs={
            "ManagementCidrRangeConstraint": management_cidr_range_constraint,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
