"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.

    Args:
        next_token(str, optional): If you received a NextToken from a previous call that was paginated, provide this token to receive the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.account.modification.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.account.modification.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="describe_account_modifications",
        op_kwargs={"NextToken": next_token},
    )
