"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.account.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.account.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="workspaces", operation="describe_account", op_kwargs={}
    )


async def modify(
    hub,
    ctx,
    dedicated_tenancy_support: str = None,
    dedicated_tenancy_management_cidr_range: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the configuration of Bring Your Own License (BYOL) for the specified account.

    Args:
        dedicated_tenancy_support(str, optional): The status of BYOL. Defaults to None.
        dedicated_tenancy_management_cidr_range(str, optional): The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as available by the ListAvailableManagementCidrRanges operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.account.init.modify(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.account.init.modify
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="modify_account",
        op_kwargs={
            "DedicatedTenancySupport": dedicated_tenancy_support,
            "DedicatedTenancyManagementCidrRange": dedicated_tenancy_management_cidr_range,
        },
    )
