"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, message_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the raw content of an in-transit email message, in MIME format.

    Args:
        message_id(str): The identifier of the email message to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmailmessageflow_raw_message_content.get(
                ctx, message_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmailmessageflow_raw_message_content.get message_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmailmessageflow",
        operation="get_raw_message_content",
        op_kwargs={"messageId": message_id},
    )


async def put(hub, ctx, message_id: str, content: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates the raw content of an in-transit email message, in MIME format. This example describes how to update in-transit email message. For more information and examples for using this API, see  Updating message content with AWS Lambda.  Updates to an in-transit message only appear when you call PutRawMessageContent from an AWS Lambda function configured with a synchronous  Run Lambda rule. If you call PutRawMessageContent on a delivered or sent message, the message remains unchanged, even though GetRawMessageContent returns an updated message.

    Args:
        message_id(str): The identifier of the email message being updated.
        content(Dict): Describes the raw message content of the updated email message.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmailmessageflow_raw_message_content.put(
                ctx, message_id=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmailmessageflow_raw_message_content.put message_id=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmailmessageflow",
        operation="put_raw_message_content",
        op_kwargs={"messageId": message_id, "content": content},
    )
