"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, organization_id: str, name: str, display_name: str, password: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user who can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.

    Args:
        organization_id(str): The identifier of the organization for which the user is created.
        name(str): The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.
        display_name(str): The display name for the new user.
        password(str): The password for the new user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.user.create(
                ctx, organization_id=value, name=value, display_name=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.user.create organization_id=value, name=value, display_name=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="create_user",
        op_kwargs={
            "OrganizationId": organization_id,
            "Name": name,
            "DisplayName": display_name,
            "Password": password,
        },
    )


async def delete(hub, ctx, organization_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must be DISABLED. Use the DescribeUser action to confirm the user state. Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are permanently removed.

    Args:
        organization_id(str): The organization that contains the user to be deleted.
        user_id(str): The identifier of the user to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.user.delete(ctx, organization_id=value, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.user.delete organization_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_user",
        op_kwargs={"OrganizationId": organization_id, "UserId": user_id},
    )


async def describe(hub, ctx, organization_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information regarding the user.

    Args:
        organization_id(str): The identifier for the organization under which the user exists.
        user_id(str): The identifier for the user to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.user.describe(
                ctx, organization_id=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.user.describe organization_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="describe_user",
        op_kwargs={"OrganizationId": organization_id, "UserId": user_id},
    )


async def list_all(
    hub, ctx, organization_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summaries of the organization's users.

    Args:
        organization_id(str): The identifier for the organization under which the users exist.
        next_token(str, optional): The token to use to retrieve the next page of results. The first call does not contain any tokens. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.user.list_all(ctx, organization_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.user.list_all organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_users",
        op_kwargs={
            "OrganizationId": organization_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
