"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def register(hub, ctx, organization_id: str, entity_id: str, email: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see Pricing. The equivalent console functionality for this operation is Enable.  Users can either be created by calling the CreateUser API operation or they can be synchronized from your directory. For more information, see DeregisterFromWorkMail.

    Args:
        organization_id(str): The identifier for the organization under which the user, group, or resource exists.
        entity_id(str): The identifier for the user, group, or resource to be updated.
        email(str): The email for the user, group, or resource to be updated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.to_work_mail.register(
                ctx, organization_id=value, entity_id=value, email=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.to_work_mail.register organization_id=value, entity_id=value, email=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="register_to_work_mail",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "Email": email,
        },
    )
