"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, organization_id: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified retention policy from the specified organization.

    Args:
        organization_id(str): The organization ID.
        id_(str): The retention policy ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.retention_policy.delete(
                ctx, organization_id=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.retention_policy.delete organization_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_retention_policy",
        op_kwargs={"OrganizationId": organization_id, "Id": id_},
    )


async def put(
    hub,
    ctx,
    organization_id: str,
    name: str,
    folder_configurations: List,
    id_: str = None,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Puts a retention policy to the specified organization.

    Args:
        organization_id(str): The organization ID.
        id_(str, optional): The retention policy ID. Defaults to None.
        name(str): The retention policy name.
        description(str, optional): The retention policy description. Defaults to None.
        folder_configurations(List): The retention policy folder configurations.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.retention_policy.put(
                ctx, organization_id=value, name=value, folder_configurations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.retention_policy.put organization_id=value, name=value, folder_configurations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="put_retention_policy",
        op_kwargs={
            "OrganizationId": organization_id,
            "Id": id_,
            "Name": name,
            "Description": description,
            "FolderConfigurations": folder_configurations,
        },
    )
