"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, organization_id: str, name: str, type_: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon WorkMail resource.

    Args:
        organization_id(str): The identifier associated with the organization for which the resource is created.
        name(str): The name of the new resource.
        type_(str): The type of the new resource. The available types are equipment and room.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.init.create(
                ctx, organization_id=value, name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.init.create organization_id=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="create_resource",
        op_kwargs={"OrganizationId": organization_id, "Name": name, "Type": type_},
    )


async def delete(hub, ctx, organization_id: str, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified resource.

    Args:
        organization_id(str): The identifier associated with the organization from which the resource is deleted.
        resource_id(str): The identifier of the resource to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.init.delete(
                ctx, organization_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.init.delete organization_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_resource",
        op_kwargs={"OrganizationId": organization_id, "ResourceId": resource_id},
    )


async def describe(hub, ctx, organization_id: str, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the data available for the resource.

    Args:
        organization_id(str): The identifier associated with the organization for which the resource is described.
        resource_id(str): The identifier of the resource to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.init.describe(
                ctx, organization_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.init.describe organization_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="describe_resource",
        op_kwargs={"OrganizationId": organization_id, "ResourceId": resource_id},
    )


async def list_all(
    hub, ctx, organization_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summaries of the organization's resources.

    Args:
        organization_id(str): The identifier for the organization under which the resources exist.
        next_token(str, optional): The token to use to retrieve the next page of results. The first call does not contain any tokens. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.init.list_all(ctx, organization_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.init.list_all organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_resources",
        op_kwargs={
            "OrganizationId": organization_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def tag(hub, ctx, resource_arn: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Applies the specified tags to the specified Amazon WorkMail organization resource.

    Args:
        resource_arn(str): The resource ARN.
        tags(List): The tag key-value pairs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.init.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.init.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="tag_resource",
        op_kwargs={"ResourceARN": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Untags the specified tags from the specified Amazon WorkMail organization resource.

    Args:
        resource_arn(str): The resource ARN.
        tag_keys(List): The tag keys.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.init.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.init.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="untag_resource",
        op_kwargs={"ResourceARN": resource_arn, "TagKeys": tag_keys},
    )


async def update(
    hub,
    ctx,
    organization_id: str,
    resource_id: str,
    name: str = None,
    booking_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates data for the resource. To have the latest information, it must be preceded by a DescribeResource call. The dataset in the request should be the one expected when performing another DescribeResource call.

    Args:
        organization_id(str): The identifier associated with the organization for which the resource is updated.
        resource_id(str): The identifier of the resource to be updated.
        name(str, optional): The name of the resource to be updated. Defaults to None.
        booking_options(Dict, optional): The resource's booking options to be updated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.init.update(
                ctx, organization_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.init.update organization_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="update_resource",
        op_kwargs={
            "OrganizationId": organization_id,
            "ResourceId": resource_id,
            "Name": name,
            "BookingOptions": booking_options,
        },
    )
