"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    organization_id: str,
    resource_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on behalf of the resource.

    Args:
        organization_id(str): The identifier for the organization that contains the resource for which delegates are listed.
        resource_id(str): The identifier for the resource whose delegates are listed.
        next_token(str, optional): The token used to paginate through the delegates associated with a resource. Defaults to None.
        max_results(int, optional): The number of maximum results in a page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.resource.delegate.list_all(
                ctx, organization_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.resource.delegate.list_all organization_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_resource_delegates",
        op_kwargs={
            "OrganizationId": organization_id,
            "ResourceId": resource_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
