"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, organization_id: str, entity_id: str, email: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or swapped between an existing alias and the current primary email), and the email provided in the input is promoted as the primary.

    Args:
        organization_id(str): The organization that contains the user, group, or resource to update.
        entity_id(str): The user, group, or resource to update.
        email(str): The value of the email to be updated as primary.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.primary_email_address.update(
                ctx, organization_id=value, entity_id=value, email=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.primary_email_address.update organization_id=value, entity_id=value, email=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="update_primary_email_address",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "Email": email,
        },
    )
