"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def reset(hub, ctx, organization_id: str, user_id: str, password: str) -> Dict:
    r"""
    **Autogenerated function**

    Allows the administrator to reset the password for a user.

    Args:
        organization_id(str): The identifier of the organization that contains the user for which the password is reset.
        user_id(str): The identifier of the user for whom the password is reset.
        password(str): The new password for the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.password.reset(
                ctx, organization_id=value, user_id=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.password.reset organization_id=value, user_id=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="reset_password",
        op_kwargs={
            "OrganizationId": organization_id,
            "UserId": user_id,
            "Password": password,
        },
    )
