"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    alias: str,
    directory_id: str = None,
    client_token: str = None,
    domains: List = None,
    kms_key_arn: str = None,
    enable_interoperability: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new Amazon WorkMail directory for you. For more information, see Adding an organization in the Amazon WorkMail Administrator Guide. You can associate multiple email domains with an organization, then set your default email domain from the Amazon WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see Adding a domain and Choosing the default domain in the Amazon WorkMail Administrator Guide. Optionally, you can use a customer managed master key from AWS Key Management Service (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a default AWS managed master key for you.

    Args:
        directory_id(str, optional): The AWS Directory Service directory ID. Defaults to None.
        alias(str): The organization alias.
        client_token(str, optional): The idempotency token associated with the request. Defaults to None.
        domains(List, optional): The email domains to associate with the organization. Defaults to None.
        kms_key_arn(str, optional): The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS. Defaults to None.
        enable_interoperability(bool, optional): When true, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to true if an AD Connector directory ID is included in the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.organization.create(ctx, alias=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.organization.create alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="create_organization",
        op_kwargs={
            "DirectoryId": directory_id,
            "Alias": alias,
            "ClientToken": client_token,
            "Domains": domains,
            "KmsKeyArn": kms_key_arn,
            "EnableInteroperability": enable_interoperability,
        },
    )


async def delete(
    hub, ctx, organization_id: str, delete_directory: bool, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see Removing an organization in the Amazon WorkMail Administrator Guide.

    Args:
        client_token(str, optional): The idempotency token associated with the request. Defaults to None.
        organization_id(str): The organization ID.
        delete_directory(bool): If true, deletes the AWS Directory Service directory associated with the organization.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.organization.delete(
                ctx, organization_id=value, delete_directory=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.organization.delete organization_id=value, delete_directory=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_organization",
        op_kwargs={
            "ClientToken": client_token,
            "OrganizationId": organization_id,
            "DeleteDirectory": delete_directory,
        },
    )


async def describe(hub, ctx, organization_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides more information regarding a given organization based on its identifier.

    Args:
        organization_id(str): The identifier for the organization to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.organization.describe(ctx, organization_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.organization.describe organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="describe_organization",
        op_kwargs={"OrganizationId": organization_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns summaries of the customer's organizations.

    Args:
        next_token(str, optional): The token to use to retrieve the next page of results. The first call does not contain any tokens. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.organization.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.organization.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_organizations",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
