"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    organization_id: str,
    name: str,
    effect: str,
    client_token: str = None,
    description: str = None,
    device_types: List = None,
    not_device_types: List = None,
    device_models: List = None,
    not_device_models: List = None,
    device_operating_systems: List = None,
    not_device_operating_systems: List = None,
    device_user_agents: List = None,
    not_device_user_agents: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new mobile device access rule for the specified Amazon WorkMail organization.

    Args:
        organization_id(str): The Amazon WorkMail organization under which the rule will be created.
        client_token(str, optional): The idempotency token for the client request. Defaults to None.
        name(str): The rule name.
        description(str, optional): The rule description. Defaults to None.
        effect(str): The effect of the rule when it matches. Allowed values are ALLOW or DENY.
        device_types(List, optional): Device types that the rule will match. Defaults to None.
        not_device_types(List, optional): Device types that the rule will not match. All other device types will match. Defaults to None.
        device_models(List, optional): Device models that the rule will match. Defaults to None.
        not_device_models(List, optional): Device models that the rule will not match. All other device models will match. Defaults to None.
        device_operating_systems(List, optional): Device operating systems that the rule will match. Defaults to None.
        not_device_operating_systems(List, optional): Device operating systems that the rule will not match. All other device operating systems will match. Defaults to None.
        device_user_agents(List, optional): Device user agents that the rule will match. Defaults to None.
        not_device_user_agents(List, optional): Device user agents that the rule will not match. All other device user agents will match. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mobile_device_access.rule.create(
                ctx, organization_id=value, name=value, effect=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mobile_device_access.rule.create organization_id=value, name=value, effect=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="create_mobile_device_access_rule",
        op_kwargs={
            "OrganizationId": organization_id,
            "ClientToken": client_token,
            "Name": name,
            "Description": description,
            "Effect": effect,
            "DeviceTypes": device_types,
            "NotDeviceTypes": not_device_types,
            "DeviceModels": device_models,
            "NotDeviceModels": not_device_models,
            "DeviceOperatingSystems": device_operating_systems,
            "NotDeviceOperatingSystems": not_device_operating_systems,
            "DeviceUserAgents": device_user_agents,
            "NotDeviceUserAgents": not_device_user_agents,
        },
    )


async def delete(
    hub, ctx, organization_id: str, mobile_device_access_rule_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a mobile device access rule for the specified Amazon WorkMail organization.

    Args:
        organization_id(str): The Amazon WorkMail organization under which the rule will be deleted.
        mobile_device_access_rule_id(str): The identifier of the rule to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mobile_device_access.rule.delete(
                ctx, organization_id=value, mobile_device_access_rule_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mobile_device_access.rule.delete organization_id=value, mobile_device_access_rule_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_mobile_device_access_rule",
        op_kwargs={
            "OrganizationId": organization_id,
            "MobileDeviceAccessRuleId": mobile_device_access_rule_id,
        },
    )


async def list_all(hub, ctx, organization_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the mobile device access rules for the specified Amazon WorkMail organization.

    Args:
        organization_id(str): The Amazon WorkMail organization for which to list the rules.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mobile_device_access.rule.list_all(
                ctx, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mobile_device_access.rule.list_all organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_mobile_device_access_rules",
        op_kwargs={"OrganizationId": organization_id},
    )


async def update(
    hub,
    ctx,
    organization_id: str,
    mobile_device_access_rule_id: str,
    name: str,
    effect: str,
    description: str = None,
    device_types: List = None,
    not_device_types: List = None,
    device_models: List = None,
    not_device_models: List = None,
    device_operating_systems: List = None,
    not_device_operating_systems: List = None,
    device_user_agents: List = None,
    not_device_user_agents: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a mobile device access rule for the specified Amazon WorkMail organization.

    Args:
        organization_id(str): The Amazon WorkMail organization under which the rule will be updated.
        mobile_device_access_rule_id(str): The identifier of the rule to be updated.
        name(str): The updated rule name.
        description(str, optional): The updated rule description. Defaults to None.
        effect(str): The effect of the rule when it matches. Allowed values are ALLOW or DENY.
        device_types(List, optional): Device types that the updated rule will match. Defaults to None.
        not_device_types(List, optional): Device types that the updated rule will not match. All other device types will match. Defaults to None.
        device_models(List, optional): Device models that the updated rule will match. Defaults to None.
        not_device_models(List, optional): Device models that the updated rule will not match. All other device models will match. Defaults to None.
        device_operating_systems(List, optional): Device operating systems that the updated rule will match. Defaults to None.
        not_device_operating_systems(List, optional): Device operating systems that the updated rule will not match. All other device operating systems will match. Defaults to None.
        device_user_agents(List, optional): User agents that the updated rule will match. Defaults to None.
        not_device_user_agents(List, optional): User agents that the updated rule will not match. All other user agents will match. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mobile_device_access.rule.update(
                ctx,
                organization_id=value,
                mobile_device_access_rule_id=value,
                name=value,
                effect=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mobile_device_access.rule.update organization_id=value, mobile_device_access_rule_id=value, name=value, effect=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="update_mobile_device_access_rule",
        op_kwargs={
            "OrganizationId": organization_id,
            "MobileDeviceAccessRuleId": mobile_device_access_rule_id,
            "Name": name,
            "Description": description,
            "Effect": effect,
            "DeviceTypes": device_types,
            "NotDeviceTypes": not_device_types,
            "DeviceModels": device_models,
            "NotDeviceModels": not_device_models,
            "DeviceOperatingSystems": device_operating_systems,
            "NotDeviceOperatingSystems": not_device_operating_systems,
            "DeviceUserAgents": device_user_agents,
            "NotDeviceUserAgents": not_device_user_agents,
        },
    )
