"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    organization_id: str,
    device_type: str = None,
    device_model: str = None,
    device_operating_system: str = None,
    device_user_agent: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access rules for the Amazon WorkMail organization for a particular user's attributes.

    Args:
        organization_id(str): The Amazon WorkMail organization to simulate the access effect for.
        device_type(str, optional): Device type the simulated user will report. Defaults to None.
        device_model(str, optional): Device model the simulated user will report. Defaults to None.
        device_operating_system(str, optional): Device operating system the simulated user will report. Defaults to None.
        device_user_agent(str, optional): Device user agent the simulated user will report. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mobile_device_access.effect.get(
                ctx, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mobile_device_access.effect.get organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="get_mobile_device_access_effect",
        op_kwargs={
            "OrganizationId": organization_id,
            "DeviceType": device_type,
            "DeviceModel": device_model,
            "DeviceOperatingSystem": device_operating_system,
            "DeviceUserAgent": device_user_agent,
        },
    )
