"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, organization_id: str, group_id: str, member_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a member (user or group) to the group's set.

    Args:
        organization_id(str): The organization under which the group exists.
        group_id(str): The group to which the member (user or group) is associated.
        member_id(str): The member (user or group) to associate to the group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.member.to_group.associate(
                ctx, organization_id=value, group_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.member.to_group.associate organization_id=value, group_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="associate_member_to_group",
        op_kwargs={
            "OrganizationId": organization_id,
            "GroupId": group_id,
            "MemberId": member_id,
        },
    )
