"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, organization_id: str, group_id: str, member_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a member from a group.

    Args:
        organization_id(str): The identifier for the organization under which the group exists.
        group_id(str): The identifier for the group from which members are removed.
        member_id(str): The identifier for the member to be removed to the group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.member.from_group.disassociate(
                ctx, organization_id=value, group_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.member.from_group.disassociate organization_id=value, group_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="disassociate_member_from_group",
        op_kwargs={
            "OrganizationId": organization_id,
            "GroupId": group_id,
            "MemberId": member_id,
        },
    )
