"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, organization_id: str, user_id: str, mailbox_quota: int
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a user's current mailbox quota for a specified organization and user.

    Args:
        organization_id(str): The identifier for the organization that contains the user for whom to update the mailbox quota.
        user_id(str): The identifer for the user for whom to update the mailbox quota.
        mailbox_quota(int): The updated mailbox quota, in MB, for the specified user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.quota.update(
                ctx, organization_id=value, user_id=value, mailbox_quota=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.quota.update organization_id=value, user_id=value, mailbox_quota=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="update_mailbox_quota",
        op_kwargs={
            "OrganizationId": organization_id,
            "UserId": user_id,
            "MailboxQuota": mailbox_quota,
        },
    )
