"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(
    hub, ctx, organization_id: str, entity_id: str, grantee_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes permissions granted to a member (user or group).

    Args:
        organization_id(str): The identifier of the organization under which the member (user or group) exists.
        entity_id(str): The identifier of the member (user or group) that owns the mailbox.
        grantee_id(str): The identifier of the member (user or group) for which to delete granted permissions.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.permission.delete_multiple(
                ctx, organization_id=value, entity_id=value, grantee_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.permission.delete_multiple organization_id=value, entity_id=value, grantee_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_mailbox_permissions",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "GranteeId": grantee_id,
        },
    )


async def list_all(
    hub,
    ctx,
    organization_id: str,
    entity_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the mailbox permissions associated with a user, group, or resource mailbox.

    Args:
        organization_id(str): The identifier of the organization under which the user, group, or resource exists.
        entity_id(str): The identifier of the user, group, or resource for which to list mailbox permissions.
        next_token(str, optional): The token to use to retrieve the next page of results. The first call does not contain any tokens. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.permission.list_all(
                ctx, organization_id=value, entity_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.permission.list_all organization_id=value, entity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_mailbox_permissions",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def put_multiple(
    hub,
    ctx,
    organization_id: str,
    entity_id: str,
    grantee_id: str,
    permission_values: List,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.

    Args:
        organization_id(str): The identifier of the organization under which the user, group, or resource exists.
        entity_id(str): The identifier of the user, group, or resource for which to update mailbox permissions.
        grantee_id(str): The identifier of the user, group, or resource to which to grant the permissions.
        permission_values(List): The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.permission.put_multiple(
                ctx,
                organization_id=value,
                entity_id=value,
                grantee_id=value,
                permission_values=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.permission.put_multiple organization_id=value, entity_id=value, grantee_id=value, permission_values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="put_mailbox_permissions",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "GranteeId": grantee_id,
            "PermissionValues": permission_values,
        },
    )
