"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(
    hub, ctx, client_token: str, job_id: str, organization_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a mailbox export job.  If the mailbox export job is near completion, it might not be possible to cancel it.

    Args:
        client_token(str): The idempotency token for the client request.
        job_id(str): The job ID.
        organization_id(str): The organization ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.export_job.cancel(
                ctx, client_token=value, job_id=value, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.export_job.cancel client_token=value, job_id=value, organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="cancel_mailbox_export_job",
        op_kwargs={
            "ClientToken": client_token,
            "JobId": job_id,
            "OrganizationId": organization_id,
        },
    )


async def describe(hub, ctx, job_id: str, organization_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the current status of a mailbox export job.

    Args:
        job_id(str): The mailbox export job ID.
        organization_id(str): The organization ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.export_job.describe(
                ctx, job_id=value, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.export_job.describe job_id=value, organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="describe_mailbox_export_job",
        op_kwargs={"JobId": job_id, "OrganizationId": organization_id},
    )


async def list_all(
    hub, ctx, organization_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the mailbox export jobs started for the specified organization within the last seven days.

    Args:
        organization_id(str): The organization ID.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.export_job.list_all(ctx, organization_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.export_job.list_all organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_mailbox_export_jobs",
        op_kwargs={
            "OrganizationId": organization_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    client_token: str,
    organization_id: str,
    entity_id: str,
    role_arn: str,
    kms_key_arn: str,
    s3_bucket_name: str,
    s3_prefix: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see Exporting mailbox content in the Amazon WorkMail Administrator Guide.

    Args:
        client_token(str): The idempotency token for the client request.
        organization_id(str): The identifier associated with the organization.
        entity_id(str): The identifier of the user or resource associated with the mailbox.
        description(str, optional): The mailbox export job description. Defaults to None.
        role_arn(str): The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.
        kms_key_arn(str): The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.
        s3_bucket_name(str): The name of the S3 bucket.
        s3_prefix(str): The S3 bucket prefix.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.export_job.start(
                ctx,
                client_token=value,
                organization_id=value,
                entity_id=value,
                role_arn=value,
                kms_key_arn=value,
                s3_bucket_name=value,
                s3_prefix=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.export_job.start client_token=value, organization_id=value, entity_id=value, role_arn=value, kms_key_arn=value, s3_bucket_name=value, s3_prefix=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="start_mailbox_export_job",
        op_kwargs={
            "ClientToken": client_token,
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "Description": description,
            "RoleArn": role_arn,
            "KmsKeyArn": kms_key_arn,
            "S3BucketName": s3_bucket_name,
            "S3Prefix": s3_prefix,
        },
    )
