"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, organization_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Requests a user's mailbox details for a specified organization and user.

    Args:
        organization_id(str): The identifier for the organization that contains the user whose mailbox details are being requested.
        user_id(str): The identifier for the user whose mailbox details are being requested.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.mailbox.detail.get_all(
                ctx, organization_id=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.mailbox.detail.get_all organization_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="get_mailbox_details",
        op_kwargs={"OrganizationId": organization_id, "UserId": user_id},
    )
