"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    organization_id: str,
    group_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an overview of the members of a group. Users and groups can be members of a group.

    Args:
        organization_id(str): The identifier for the organization under which the group exists.
        group_id(str): The identifier for the group to which the members (users or groups) are associated.
        next_token(str, optional):  The token to use to retrieve the next page of results. The first call does not contain any tokens. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.group.member.list_all(
                ctx, organization_id=value, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.group.member.list_all organization_id=value, group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_group_members",
        op_kwargs={
            "OrganizationId": organization_id,
            "GroupId": group_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
