"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, organization_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a group that can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.

    Args:
        organization_id(str): The organization under which the group is to be created.
        name(str): The name of the group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.group.init.create(
                ctx, organization_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.group.init.create organization_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="create_group",
        op_kwargs={"OrganizationId": organization_id, "Name": name},
    )


async def delete(hub, ctx, organization_id: str, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a group from Amazon WorkMail.

    Args:
        organization_id(str): The organization that contains the group.
        group_id(str): The identifier of the group to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.group.init.delete(
                ctx, organization_id=value, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.group.init.delete organization_id=value, group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_group",
        op_kwargs={"OrganizationId": organization_id, "GroupId": group_id},
    )


async def describe(hub, ctx, organization_id: str, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the data available for the group.

    Args:
        organization_id(str): The identifier for the organization under which the group exists.
        group_id(str): The identifier for the group to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.group.init.describe(
                ctx, organization_id=value, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.group.init.describe organization_id=value, group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="describe_group",
        op_kwargs={"OrganizationId": organization_id, "GroupId": group_id},
    )


async def list_all(
    hub, ctx, organization_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summaries of the organization's groups.

    Args:
        organization_id(str): The identifier for the organization under which the groups exist.
        next_token(str, optional): The token to use to retrieve the next page of results. The first call does not contain any tokens. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.group.init.list_all(ctx, organization_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.group.init.list_all organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_groups",
        op_kwargs={
            "OrganizationId": organization_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
