"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, organization_id: str, entity_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The functionality in the console is Disable.

    Args:
        organization_id(str): The identifier for the organization under which the Amazon WorkMail entity exists.
        entity_id(str): The identifier for the member (user or group) to be updated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.from_work_mail.deregister(
                ctx, organization_id=value, entity_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.from_work_mail.deregister organization_id=value, entity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="deregister_from_work_mail",
        op_kwargs={"OrganizationId": organization_id, "EntityId": entity_id},
    )
