"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, organization_id: str, resource_id: str, entity_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a member (user or group) to the resource's set of delegates.

    Args:
        organization_id(str): The organization under which the resource exists.
        resource_id(str): The resource for which members (users or groups) are associated.
        entity_id(str): The member (user or group) to associate to the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.delegate.to_resource.associate(
                ctx, organization_id=value, resource_id=value, entity_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.delegate.to_resource.associate organization_id=value, resource_id=value, entity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="associate_delegate_to_resource",
        op_kwargs={
            "OrganizationId": organization_id,
            "ResourceId": resource_id,
            "EntityId": entity_id,
        },
    )
