"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, organization_id: str, resource_id: str, entity_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a member from the resource's set of delegates.

    Args:
        organization_id(str): The identifier for the organization under which the resource exists.
        resource_id(str): The identifier of the resource from which delegates' set members are removed. .
        entity_id(str): The identifier for the member (user, group) to be removed from the resource's delegates.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.delegate.from_resource.disassociate(
                ctx, organization_id=value, resource_id=value, entity_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.delegate.from_resource.disassociate organization_id=value, resource_id=value, entity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="disassociate_delegate_from_resource",
        op_kwargs={
            "OrganizationId": organization_id,
            "ResourceId": resource_id,
            "EntityId": entity_id,
        },
    )
