"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, organization_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the default retention policy details for the specified organization.

    Args:
        organization_id(str): The organization ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.default_retention_policy.get(
                ctx, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.default_retention_policy.get organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="get_default_retention_policy",
        op_kwargs={"OrganizationId": organization_id},
    )
