"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, organization_id: str, entity_id: str, alias: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds an alias to the set of a given member (user or group) of Amazon WorkMail.

    Args:
        organization_id(str): The organization under which the member (user or group) exists.
        entity_id(str): The member (user or group) to which this alias is added.
        alias(str): The alias to add to the member set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.alias.create(
                ctx, organization_id=value, entity_id=value, alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.alias.create organization_id=value, entity_id=value, alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="create_alias",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "Alias": alias,
        },
    )


async def delete(hub, ctx, organization_id: str, entity_id: str, alias: str) -> Dict:
    r"""
    **Autogenerated function**

    Remove one or more specified aliases from a set of aliases for a given user.

    Args:
        organization_id(str): The identifier for the organization under which the user exists.
        entity_id(str): The identifier for the member (user or group) from which to have the aliases removed.
        alias(str): The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.alias.delete(
                ctx, organization_id=value, entity_id=value, alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.alias.delete organization_id=value, entity_id=value, alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_alias",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "Alias": alias,
        },
    )


async def list_all(
    hub,
    ctx,
    organization_id: str,
    entity_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a paginated call to list the aliases associated with a given entity.

    Args:
        organization_id(str): The identifier for the organization under which the entity exists.
        entity_id(str): The identifier for the entity for which to list the aliases.
        next_token(str, optional): The token to use to retrieve the next page of results. The first call does not contain any tokens. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.alias.list_all(
                ctx, organization_id=value, entity_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.alias.list_all organization_id=value, entity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_aliases",
        op_kwargs={
            "OrganizationId": organization_id,
            "EntityId": entity_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
