"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, organization_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an access control rule for the specified WorkMail organization.

    Args:
        organization_id(str): The identifier for the organization.
        name(str): The name of the access control rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.access_control.rule.delete(
                ctx, organization_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.access_control.rule.delete organization_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="delete_access_control_rule",
        op_kwargs={"OrganizationId": organization_id, "Name": name},
    )


async def list_all(hub, ctx, organization_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the access control rules for the specified organization.

    Args:
        organization_id(str): The identifier for the organization.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.access_control.rule.list_all(
                ctx, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.access_control.rule.list_all organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="list_access_control_rules",
        op_kwargs={"OrganizationId": organization_id},
    )


async def put(
    hub,
    ctx,
    name: str,
    effect: str,
    description: str,
    organization_id: str,
    ip_ranges: List = None,
    not_ip_ranges: List = None,
    actions: List = None,
    not_actions: List = None,
    user_ids: List = None,
    not_user_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the same name as an existing rule replaces the older rule.

    Args:
        name(str): The rule name.
        effect(str): The rule effect.
        description(str): The rule description.
        ip_ranges(List, optional): IPv4 CIDR ranges to include in the rule. Defaults to None.
        not_ip_ranges(List, optional): IPv4 CIDR ranges to exclude from the rule. Defaults to None.
        actions(List, optional): Access protocol actions to include in the rule. Valid values include ActiveSync, AutoDiscover, EWS, IMAP, SMTP, WindowsOutlook, and WebMail. Defaults to None.
        not_actions(List, optional): Access protocol actions to exclude from the rule. Valid values include ActiveSync, AutoDiscover, EWS, IMAP, SMTP, WindowsOutlook, and WebMail. Defaults to None.
        user_ids(List, optional): User IDs to include in the rule. Defaults to None.
        not_user_ids(List, optional): User IDs to exclude from the rule. Defaults to None.
        organization_id(str): The identifier of the organization.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.access_control.rule.put(
                ctx, name=value, effect=value, description=value, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.access_control.rule.put name=value, effect=value, description=value, organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="put_access_control_rule",
        op_kwargs={
            "Name": name,
            "Effect": effect,
            "Description": description,
            "IpRanges": ip_ranges,
            "NotIpRanges": not_ip_ranges,
            "Actions": actions,
            "NotActions": not_actions,
            "UserIds": user_ids,
            "NotUserIds": not_user_ids,
            "OrganizationId": organization_id,
        },
    )
