"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, organization_id: str, ip_address: str, action: str, user_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access protocol action, or user ID.

    Args:
        organization_id(str): The identifier for the organization.
        ip_address(str): The IPv4 address.
        action(str): The access protocol action. Valid values include ActiveSync, AutoDiscover, EWS, IMAP, SMTP, WindowsOutlook, and WebMail.
        user_id(str): The user ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workmail.access_control.effect.get(
                ctx, organization_id=value, ip_address=value, action=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workmail.access_control.effect.get organization_id=value, ip_address=value, action=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workmail",
        operation="get_access_control_effect",
        op_kwargs={
            "OrganizationId": organization_id,
            "IpAddress": ip_address,
            "Action": action,
            "UserId": user_id,
        },
    )
