"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, fleet_arn: str, certificate: str, display_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.

    Args:
        fleet_arn(str): The ARN of the fleet.
        certificate(str): The root certificate of the CA.
        display_name(str, optional): The certificate name to display. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.website.certificate_authority.associate(
                ctx, fleet_arn=value, certificate=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.website.certificate_authority.associate fleet_arn=value, certificate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="associate_website_certificate_authority",
        op_kwargs={
            "FleetArn": fleet_arn,
            "Certificate": certificate,
            "DisplayName": display_name,
        },
    )


async def describe(hub, ctx, fleet_arn: str, website_ca_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about the certificate authority.

    Args:
        fleet_arn(str): The ARN of the fleet.
        website_ca_id(str): A unique identifier for the certificate authority.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.website.certificate_authority.describe(
                ctx, fleet_arn=value, website_ca_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.website.certificate_authority.describe fleet_arn=value, website_ca_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="describe_website_certificate_authority",
        op_kwargs={"FleetArn": fleet_arn, "WebsiteCaId": website_ca_id},
    )


async def disassociate(hub, ctx, fleet_arn: str, website_ca_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a certificate authority (CA).

    Args:
        fleet_arn(str): The ARN of the fleet.
        website_ca_id(str): A unique identifier for the CA.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.website.certificate_authority.disassociate(
                ctx, fleet_arn=value, website_ca_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.website.certificate_authority.disassociate fleet_arn=value, website_ca_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="disassociate_website_certificate_authority",
        op_kwargs={"FleetArn": fleet_arn, "WebsiteCaId": website_ca_id},
    )


async def list_all(
    hub, ctx, fleet_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of certificate authorities added for the current account and Region.

    Args:
        fleet_arn(str): The ARN of the fleet.
        max_results(int, optional): The maximum number of results to be included in the next page. Defaults to None.
        next_token(str, optional): The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.website.certificate_authority.list_all(
                ctx, fleet_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.website.certificate_authority.list_all fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="list_website_certificate_authorities",
        op_kwargs={
            "FleetArn": fleet_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
