"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, fleet_arn: str, authorization_provider_type: str, domain_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.

    Args:
        fleet_arn(str): The ARN of the fleet.
        authorization_provider_type(str): The authorization provider type.
        domain_name(str, optional): The domain name of the authorization provider. This applies only to SAML-based authorization providers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.website.authorization_provider.associate(
                ctx, fleet_arn=value, authorization_provider_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.website.authorization_provider.associate fleet_arn=value, authorization_provider_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="associate_website_authorization_provider",
        op_kwargs={
            "FleetArn": fleet_arn,
            "AuthorizationProviderType": authorization_provider_type,
            "DomainName": domain_name,
        },
    )


async def disassociate(
    hub, ctx, fleet_arn: str, authorization_provider_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.

    Args:
        fleet_arn(str): The ARN of the fleet.
        authorization_provider_id(str): A unique identifier for the authorization provider.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.website.authorization_provider.disassociate(
                ctx, fleet_arn=value, authorization_provider_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.website.authorization_provider.disassociate fleet_arn=value, authorization_provider_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="disassociate_website_authorization_provider",
        op_kwargs={
            "FleetArn": fleet_arn,
            "AuthorizationProviderId": authorization_provider_id,
        },
    )


async def list_all(
    hub, ctx, fleet_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of website authorization providers associated with a specified fleet.

    Args:
        fleet_arn(str): The ARN of the fleet.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        max_results(int, optional): The maximum number of results to be included in the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.website.authorization_provider.list_all(
                ctx, fleet_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.website.authorization_provider.list_all fleet_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="list_website_authorization_providers",
        op_kwargs={
            "FleetArn": fleet_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
