"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def sign(hub, ctx, fleet_arn: str, username: str) -> Dict:
    r"""
    **Autogenerated function**

    Signs the user out from all of their devices. The user can sign in again if they have valid credentials.

    Args:
        fleet_arn(str): The ARN of the fleet.
        username(str): The name of the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.worklink.out_user.sign(ctx, fleet_arn=value, username=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.worklink.out_user.sign fleet_arn=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="worklink",
        operation="sign_out_user",
        op_kwargs={"FleetArn": fleet_arn, "Username": username},
    )
